/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2017-2019 Ping Identity Corporation
 */


package com.unboundid.directory.sdk.broker.types;

import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

/**
 * Exception that may be thrown by a Policy Obligation to indicate that
 * the obligation could not be fulfilled.  This will cause the underlying
 * operation to be aborted with an unauthorized error return.
 */
@NotExtensible()
@NotMutable()
@ThreadSafety(level= ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public class NotFulfilledException extends Exception {

  private static final long serialVersionUID = -1188773073096459645L;


  /**
   * Create a NotfulfilledException with the provided message.
   * @param message   The message to use for this exception.
   */
  public NotFulfilledException(final String message) {
    super(message);
  }


  /**
   * Create a NotfulfilledException with the provided message and cause.
   * @param message   The message to use for this exception.
   * @param cause     The underlying cause for this exception.  It may
   *                  be {@code null} if no cause is available.
   */
  public NotFulfilledException(
      final String message,
      final Throwable cause) {
    super(message, cause);
  }
}
