/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2018-2019 Ping Identity Corporation
 */


package com.unboundid.directory.sdk.broker.types;

/**
 * Specifies the response to be returned to an Open Banking client from
 * denied-reason policy advice.
 */
public class OpenBankingErrorResponse {

  private String errorMessage;

  private int status;

  /**
   * Constructor.
   * @param statusCode The HTTP status code to be returned to the client.
   */
  public OpenBankingErrorResponse(final int statusCode) {
    this.status = statusCode;
  }

  /**
   * Get the error message that will be returned in the HTTP response body.
   * @return An error message explaining the reason the request was denied.
   */
  public String getErrorMessage() {
    return errorMessage;
  }

  /**
   * Set the error message to be returned in the HTTP response body.
   * @param errorMessage An error message explaining the reason the request
   *                     was denied.
   */
  public void setErrorMessage(final String errorMessage) {
    this.errorMessage = errorMessage;
  }

  /**
   * Get the HTTP status code to be returned in the client response.
   * @return the HTTP status code.
   */
  public int getStatus() {
    return status;
  }
}
