/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2018-2019 Ping Identity Corporation
 */

package com.unboundid.directory.sdk.broker.types;

/**
 * Object passed to Obligation and Advice implementations containing
 * information about the policy request that triggered the return of
 * the Obligation or Advice.
 */
public interface PolicyRequestDetails {

  /**
   * Get the action for which authorization was requested.
   * @return the action string that was passed in the policy request.
   */
  String getAction();

  /**
   * Get the path to the resource for which authorization was requested.
   * @return the resource path.
   */
  String getResourcePath();

  /**
   * Get the type of resource to which authorization was requested.
   * @return a string representing the resource type, as defined by
   * the Policy Enforcement Point that made the authorization request.
   */
  String getResourceType();

  /**
   * Get the decision returned from the authorization request.
   * @return PolicyDecision enum represeting either Permit or Deny.
   */
  PolicyDecision getDecision();
}
