/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * trunk/ds/resource/legal-notices/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * trunk/ds/resource/legal-notices/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2016-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.broker.types;

import com.unboundid.util.NotExtensible;

import java.security.Principal;



/**
 * A principal implementation for users retrievable as SCIM resources.
 */
@NotExtensible()
public interface ScimResourcePrincipal extends Principal
{
  /**
   * Get the SCIM resource endpoint for this user.
   *
   * @return the SCIM resource endpoint for this user.
   */
  String getResourceEndpoint();



  /**
   * Get the SCIM resource ID for this user.
   *
   * @return the SCIM resource ID for this user.
   */
  String getResourceId();



  /**
   * Returns the name of this principal.
   *
   * @return the name of this principal.
   */
  @Override
  String getName();
}
