/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2016-2019 Ping Identity Corporation
 */

package com.unboundid.directory.sdk.broker.types;

import com.unboundid.util.NotExtensible;

import javax.servlet.http.HttpServletRequest;

/**
 * Represents a status request to be processed by a Server SDK Identity
 * Authenticator.
 */
@NotExtensible
public interface StatusRequest
{
  /**
   * Retrieve the currently authenticated principal or
   * {@code null} if not available.
   *
   * @return  The currently authenticated principal or
   *          {@code null} if not available.
   */
  ScimResourcePrincipal getPrincipal();



  /**
   * Retrieve a JSON object specifying the flow state parameters.
   * Never {@code null}.
   * This string can be parsed using any JSON library. For example,
   * Jackson's ObjectMapper.readTree() or the UnboundID LDAP SDK's JSONObject
   * constructor.
   *
   * @return  A JSON object specifying the flow state parameters.
   */
  String getStateParameters();



  /**
   * Retrieve the HTTP servlet request for the request being processed.
   * @return  The HTTP servlet request for the request being processed.
   */
  HttpServletRequest getHttpServletRequest();
}
