/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2013-2019 Ping Identity Corporation
 */

package com.unboundid.directory.sdk.broker.types;


import com.unboundid.util.NotExtensible;


/**
 * Represents a request to delete a specific entry from a Store Adapter.
 */
@NotExtensible
public interface StoreDeleteRequest
    extends StoreRequest
{
  /**
   * Retrieve the SCIM filter which identifies the entry to be deleted.
   * The UnboundID scim2 SDK Filter class can be used to parse a SCIM filter.
   *
   * @return  The SCIM filter which identifies the entry to be deleted.
   */
  String getSCIMFilter();
}
