/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2016-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.broker.types;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.unboundid.scim2.common.filters.Filter;
import com.unboundid.scim2.common.messages.PatchRequest;

/**
 * Request context for the method after an entry is updated in the
 * native data store.
 */
public interface StorePostUpdateRequestContext extends StoreRequestContext
{
  /**
   * Retrieve the filter which identifies the entry that was updated.
   *
   * @return  The filter which identifies the entry that was updated.
   */
  Filter getSCIMFilter();

  /**
   * Retrieve the SCIM patch request specifying the modifications that were
   * processed.
   *
   * @return  The SCIM patch request specifying the modifications that were
   * processed.
   */
  PatchRequest getPatchRequest();

  /**
   * Retrieves the updated object returned by the store adapter.
   * The plugin may make changes directly to this object.
   *
   * @return The updated object returned by the store adapter.
   */
  ObjectNode getUpdatedObject();
}
