/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2016-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.broker.types;

import com.unboundid.scim2.common.filters.Filter;

/**
 * Request context for the method called before searching for entries in the
 * native data store.
 */
public interface StorePreSearchRequestContext extends StoreRequestContext
{
  /**
   * Retrieves the SCIM Filter associated with this search request.
   *
   * @return  The SCIM Filter that should be used. This may be {@code null} if
   *          no filtering is required.
   */
  Filter getSCIMFilter();

  /**
   * Sets the SCIM Filter associated with this search request.
   * This filter will be used to search for entries in the native data store;
   * before returning the search result set to the client, the
   * ${BROKER_BASE_NAME} will filter the result set further using the original
   * search filter.
   *
   * @param scimFilter The SCIM Filter that should be used.
   */
  void setSCIMFilter(Filter scimFilter);
}
