/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2013-2019 Ping Identity Corporation
 */

package com.unboundid.directory.sdk.broker.types;

import com.unboundid.util.NotExtensible;



/**
 * Represents a search request to retrieve entries from a Store Adapter.
 */
@NotExtensible
public interface StoreSearchRequest
    extends StoreRequest
{
  /**
   * Retrieve the result listener that will be used to return results to the
   * caller.
   *
   * @return  The result listener that will be used to return results to the
   *          caller.
   */
  StoreSearchResultListener getStoreSearchResultListener();

  /**
   * Retrieves the SCIM Filter associated with this search request.
   * The UnboundID scim2 SDK Filter class can be used to parse a SCIM filter.
   *
   * @return  The SCIM Filter that should be used. This may be {@code null} if
   *          no filtering is required.
   */
  String getSCIMFilter();

  /**
   * Retrieves the maximum number of objects the store adapter should return
   * for the search. A value of zero or less indicates that there should be
   * no limit.
   *
   * @return  The maximum number of objects the store adapter should return
   *          for the search. A value of zero or less indicates that there
   *          should be no limit.
   */
  int getSizeLimit();
}
