/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file. If applicable, add the following below this CDDL HEADER,
 * with the fields enclosed by brackets "[]" replaced with your own
 * identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2014-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.common.api;

import com.unboundid.directory.sdk.common.types.CompletedOperationContext;
import com.unboundid.directory.sdk.ds.internal.DirectoryServerExtension;
import com.unboundid.directory.sdk.proxy.internal.DirectoryProxyServerExtension;
import com.unboundid.util.Extensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

/**
 * This interface defines a set of methods that may be used to notify a server
 * SDK extension whenever an operation has completed. This is guaranteed to be
 * called for any operation that has started being processed regardless of
 * whether the operation completed successfully or not.
 */
@Extensible
@DirectoryServerExtension
@DirectoryProxyServerExtension(appliesToLocalContent = true,
    appliesToRemoteContent = true)
@ThreadSafety(level = ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
public interface OperationCompletedListener {
  /**
   * Performs any processing that might be necessary after the server has
   * completed processing an operation.
   *
   * @param  completedOperationContext   The operation context of the operation
   *                                     that completed.
   */
  void handleOperationCompleted(
      final CompletedOperationContext completedOperationContext);
}

