/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2011-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.common.config;



import java.io.File;

import com.unboundid.directory.sdk.common.types.LogWriter;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;



/**
 * This interface defines a set of methods that may be used to obtain
 * information about the general configuration for a file-based access logger.
 */
@NotExtensible()
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
public interface FileBasedAccessLoggerConfig
       extends GenericConfig
{
  /**
   * Retrieves the path to the log file to which new log messages will be
   * written.
   *
   * @return  The path to the log file to which new log messages will be
   *          written.
   */
  File getLogFile();


  /**
   * Returns the underlying writer for the server access log, which can be used
   * to log arbitrary messages back through the core server logging framework.
   *
   * @return a {@link LogWriter} instance.
   */
  LogWriter getLogWriter();
}
