/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2010-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.common.config;



import com.unboundid.directory.sdk.common.types.ServerContext;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;



/**
 * This interface defines a set of methods that may be used to obtain
 * information about the general configuration for all types of extensions.
 */
@NotExtensible()
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
public interface GenericConfig
{
  /**
   * Retrieves a handle to the server context for the server in which this
   * extension is running.
   *
   * @return  A handle to the server context for the server in which this
   *          extension is running.
   */
  ServerContext getServerContext();



  /**
   * Retrieves the DN of the entry containing the configuration for this
   * extension.
   *
   * @return  The DN of the entry containing the configuration for this
   *          extension.
   */
  String getConfigObjectDN();



  /**
   * Retrieves the name of the configuration object for this extension.  It will
   * generally be the RDN value for the configuration DN.
   *
   * @return  The name of the configuration object for this extension.
   */
  String getConfigObjectName();
}
