/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2013-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.common.config;


import com.unboundid.util.NotExtensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;


/**
 * This interface defines a set of methods that may be used to obtain
 * information about the general configuration for a Velocity context
 * provider.
 */
@NotExtensible()
@ThreadSafety(level= ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
public interface VelocityContextProviderConfig extends GenericConfig
{

  enum ObjectScope {

    /**
     * Objects added to the context should be scoped for the lifetime of
     * the application.
     */
    APPLICATION,



    /**
     * Objects added to the context should be scoped to the client's
     * session.
     */
    SESSION,



    /**
     * Objects added to the context should be scoped to the client's
     * request.
     */
    REQUEST;
  }



  /**
   * Indicates the expected scope for objects added to the Velocity
   * context by this provider.
   *
   * @return scope for objects added to the context.
   */
  ObjectScope getObjectScope();

}
