/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2010-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.common.operation;



import com.unboundid.directory.sdk.common.types.Entry;
import com.unboundid.ldap.sdk.ReadOnlyAddRequest;
import com.unboundid.ldif.LDIFAddChangeRecord;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;



/**
 * This interface defines a set of methods which may be used to interact with an
 * add request.
 */
@NotExtensible()
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
public interface AddRequest
       extends ChangeRequest
{
  /**
   * Retrieves the entry to be added.
   *
   * @return  The entry to be added.
   */
  Entry getEntry();



  /**
   * Retrieves an LDAP SDK representation of this add request.
   *
   * @return  An LDAP SDK representation of this add request.
   */
  ReadOnlyAddRequest toLDAPSDKRequest();



  /**
   * Retrieves an LDIF change record that corresponds to this add request.
   *
   * @return  An LDIF change record that corresponds to this add request.
   */
  LDIFAddChangeRecord toLDIFChangeRecord();



  /**
   * Indicates whether this {@code AddRequest} contains the {@code
   * UndeleteRequestControl}. If this method returns {@code true}, the
   * undelete control can be obtained from the {@link #getRequestControls()}
   * method.
   *
   * @return true if the {@code UndeleteRequestControl} is included in this
   *              request, false if not.
   */
  boolean isUndelete();
}
