/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2010-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.common.operation;



import com.unboundid.directory.sdk.common.types.AssuredReplicationRequirements;
import com.unboundid.directory.sdk.common.types.Entry;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;



/**
 * This interface defines a set of methods which may be used to interact with
 * delete results.
 */
@NotExtensible()
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
public interface DeleteResult
       extends GenericResult
{
  /**
   * Retrieves the entry against which the delete operation was processed, if
   * available.  This may be available for both hard and soft deletes.
   *
   * @return  The entry against which the delete operation was processed, or
   *          {@code null} if the entry is not available.
   */
  Entry getDeletedEntry();



  /**
   * Retrieves the soft-deleted entry if this {@code DeleteResult} is in
   * response to a soft-delete request.
   *
   * @return  The soft-deleted entry, or {@code null} if the original request
   *          was not a soft delete request or the entry is not available.
   */
  Entry getSoftDeletedEntry();



  /**
   * Retrieves the assured replication requirements that will be used for this
   * operation, if any.
   *
   * @return  The assured replication requirements that will be used for this
   *          operation, or {@code null} if no assurance will be provided for
   *          this operation.
   */
  AssuredReplicationRequirements getAssuredReplicationRequirements();
}
