/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2010-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.common.operation;



import java.util.List;

import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;



/**
 * This interface defines a set of methods which may be used to interact with
 * properties common to most types of LDAP results.
 */
@NotExtensible()
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
public interface GenericResult
       extends Result
{
  /**
   * Retrieves the result code for the result.
   *
   * @return  The result code for the result.
   */
  ResultCode getResultCode();



  /**
   * Retrieves the matched DN for the result, if any.
   *
   * @return  The matched DN for the result, or {@code null} if there is none.
   */
  String getMatchedDN();



  /**
   * Retrieves the diagnostic message for the result, if any.
   *
   * @return  The diagnostic message for the result, or {@code null} if there
   *          is none.
   */
  String getDiagnosticMessage();



  /**
   * Retrieves the referral URLs for the result.
   *
   * @return  The referral URLs for the result, or an empty list if there are
   *          none.
   */
  List<String> getReferralURLs();



  /**
   * Retrieves an additional log message for the result which will not be
   * returned to the client but may be included in access log messages for the
   * associated operation.
   *
   * @return  An additional log message for the result.
   */
  String getAdditionalLogMessage();



  /**
   * Retrieves an LDAP SDK representation of this result.
   *
   * @return  An LDAP SDK representation of this result.
   */
  LDAPResult toLDAPSDKResult();
}
