/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2010-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.common.operation;



import com.unboundid.ldap.sdk.ReadOnlyModifyDNRequest;
import com.unboundid.ldif.LDIFModifyDNChangeRecord;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;



/**
 * This interface defines a set of methods which may be used to interact with a
 * modify DN request.
 */
@NotExtensible()
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
public interface ModifyDNRequest
       extends ChangeRequest
{
  /**
   * Retrieves the DN of the entry to move and/or rename.
   *
   * @return  The DN of the entry to move and/or rename.
   */
  String getDN();



  /**
   * Retrieves the new RDN to use for the entry.
   *
   * @return  The new RDN to use for the entry.
   */
  String getNewRDN();



  /**
   * Indicates whether to remove the old RDN values from the entry.
   *
   * @return  {@code true} if the old RDN values should be removed, or
   *          {@code false} if not.
   */
  boolean deleteOldRDN();



  /**
   * Retrieves the DN for the new superior entry, if any.
   *
   * @return  The DN for the new superior entry, or {@code null} if the entry
   *          should remain below its current parent.
   */
  String getNewSuperiorDN();



  /**
   * Retrieves an LDAP SDK representation of this modify DN request.
   *
   * @return  An LDAP SDK representation of this modify DN request.
   */
  ReadOnlyModifyDNRequest toLDAPSDKRequest();



  /**
   * Retrieves an LDIF change record that corresponds to this modify DN request.
   *
   * @return  An LDIF change record that corresponds to this modify DN request.
   */
  LDIFModifyDNChangeRecord toLDIFChangeRecord();
}
