/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2010-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.common.operation;



import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;



/**
 * This interface defines a set of methods which may be used to interact with a
 * SASL bind request.
 */
@NotExtensible()
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
public interface SASLBindRequest
       extends BindRequest
{
  /**
   * Retrieves the name of the SASL mechanism to use.
   *
   * @return  The name of the SASL mechanism to use.
   */
  String getSASLMechanism();



  /**
   * Retrieves the SASL credentials for the bind request, if any.
   *
   * @return  The SASL credentials for the bind request, or {@code null} if
   *          there are none.
   */
  ASN1OctetString getSASLCredentials();



  /**
   * Retrieves an LDAP SDK representation of this SASL bind request.
   *
   * @return  An LDAP SDK representation of this SASL bind request.
   */
  com.unboundid.ldap.sdk.SASLBindRequest toLDAPSDKRequest();
}
