/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2010-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.common.operation;



import java.util.List;

import com.unboundid.ldap.sdk.DereferencePolicy;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.ReadOnlySearchRequest;
import com.unboundid.ldap.sdk.SearchResultListener;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;



/**
 * This interface defines a set of methods which may be used to interact with a
 * search request.
 */
@NotExtensible()
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
public interface SearchRequest
       extends Request
{
  /**
   * Retrieves the base DN for the search.
   *
   * @return  The base DN for the search.
   */
  String getBaseDN();



  /**
   * Retrieves the scope for the search.
   *
   * @return  The scope for the search.
   */
  SearchScope getScope();



  /**
   * Retrieves the dereference policy for the search.
   *
   * @return  The dereference policy for the search.
   */
  DereferencePolicy getDerefPolicy();



  /**
   * Retrieves the size limit for the search.
   *
   * @return  The size limit for the search, or zero if no size limit should be
   *          requested.
   */
  int getSizeLimit();



  /**
   * Retrieves the time limit for the search in seconds.
   *
   * @return  The time limit for the search in seconds, or zero if no time limit
   *          should be requested.
   */
  int getTimeLimitSeconds();



  /**
   * Indicates whether search result entries should contain only attribute types
   * or both types and values.
   *
   * @return  {@code true} if search result entries should contain only
   *          attribute types but no values, or {@code false} if entries should
   *          contain both attribute types and values.
   */
  boolean getTypesOnly();



  /**
   * Retrieves the filter for the search.
   *
   * @return  The filter for the search.
   */
  Filter getFilter();



  /**
   * Retrieves the list of requested attributes.
   *
   * @return  The list of requested attributes.
   */
  List<String> getAttributes();



  /**
   * Retrieves an LDAP SDK representation of this search request.
   *
   * @param  listener  The search result listener that should be used for the
   *                   request.  It may be {@code null} if no listener should be
   *                   used.
   *
   * @return  An LDAP SDK representation of this search request.
   */
  ReadOnlySearchRequest toLDAPSDKRequest(final SearchResultListener listener);
}
