/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2010-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.common.operation;



import java.util.List;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;



/**
 * This interface defines a set of methods which may be used to update the
 * contents of operation results.
 */
@NotExtensible()
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
public interface UpdatableGenericResult
       extends GenericResult, UpdatableResult
{
  /**
   * Specifies the result code for the result.
   *
   * @param  resultCode  The result code for the result.  It must not be
   *                     {@code null}.
   */
  void setResultCode(final ResultCode resultCode);



  /**
   * Specifies the matched DN for the result, if any.
   *
   * @param  matchedDN  The matched DN for the result.  It may be {@code null}
   *                    if there is none.
   *
   * @throws LDAPException  If the provided DN cannot be parsed.
   */
  void setMatchedDN(final String matchedDN)
       throws LDAPException;



  /**
   * Specifies the diagnostic message for the result, if any.
   *
   * @param  diagnosticMessage  The diagnostic message for the result.  It may
   *         be {@code null} if there is none.
   */
  void setDiagnosticMessage(final String diagnosticMessage);



  /**
   * Specifies the referral URLs for the result.
   *
   * @param  referralURLs  The referral URLs for the result.  It may be
   *                       {@code null} or empty if there are none.
   */
  void setReferralURLs(final List<String> referralURLs);



  /**
   * Specifies an additional log message for the result which will not be
   * returned to the client but may be included in access log messages for the
   * associated operation.
   *
   * @param  message  An additional log message for the result.
   */
  void setAdditionalLogMessage(final String message);



  /**
   * Sets the contents of this result with information from the provided
   * LDAP result, including the result code, diagnostic message, matched DN,
   * referral URLs, and controls.
   *
   * @param  result  The result to use to update this result.  It must not be
   *                 {@code null}.
   */
  void setResultData(final LDAPResult result);



  /**
   * Sets the contents of this result with information from the provided
   * LDAP exception, including the result code, diagnostic message, matched DN,
   * referral URLs, and controls.
   *
   * @param  le  The exception to use to update this result.  It must not be
   *             {@code null}.
   */
  void setResultData(final LDAPException le);
}
