/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2010-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.common.operation;



import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.RDN;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;



/**
 * This interface defines a set of methods which may be used to update a modify
 * DN request.
 */
@NotExtensible()
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
public interface UpdatableModifyDNRequest
       extends ModifyDNRequest, UpdatableRequest
{
  /**
   * Specifies the DN of the entry to move and/or rename.
   *
   * @param  dn  The DN of the entry to move and/or rename.  It must not be
   *             {@code null}.
   */
  void setDN(final String dn);



  /**
   * Specifies the DN of the entry to move and/or rename.
   *
   * @param  dn  The DN of the entry to move and/or rename.  It must not be
   *             {@code null}.
   */
  void setDN(final DN dn);



  /**
   * Specifies the new RDN to use for the entry.
   *
   * @param  newRDN  The new RDN to use for the entry.  It must not be
   *                 {@code null}.
   */
  void setNewRDN(final String newRDN);



  /**
   * Specifies the new RDN to use for the entry.
   *
   * @param  newRDN  The new RDN to use for the entry.  It must not be
   *                 {@code null}.
   */
  void setNewRDN(final RDN newRDN);



  /**
   * Specifies whether to remove the old RDN values from the entry.
   *
   * @param  deleteOldRDN  Indicates whether to remove the old RDN values from
   *                       the entry.
   */
  void setDeleteOldRDN(final boolean deleteOldRDN);



  /**
   * Specifies the DN for the new superior entry, if any.
   *
   * @param  newSuperiorDN  The DN for the new superior entry.  It may be
   *                        {@code null} if the entry should remain below its
   *                        current parent.
   */
  void setNewSuperiorDN(final String newSuperiorDN);



  /**
   * Specifies the DN for the new superior entry, if any.
   *
   * @param  newSuperiorDN  The DN for the new superior entry.  It may be
   *                        {@code null} if the entry should remain below its
   *                        current parent.
   */
  void setNewSuperiorDN(final DN newSuperiorDN);
}
