/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2010-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.common.operation;



import java.util.List;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;



/**
 * This interface defines a set of methods which may be used to update the
 * contents of operation results.
 */
@NotExtensible()
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
public interface UpdatableResult
       extends Result
{
  /**
   * Updates the set of result controls for this result.
   *
   * @param  controls  The set of controls to use for this result.  It may be
   *                   {@code null} or empty if there should not be any
   *                   controls.
   */
  void setResultControls(final List<Control> controls);



  /**
   * Adds the provided control to the set of result controls for this result.
   *
   * @param  control  The control to be added to the set of result controls for
   *                  this result.  It must not be {@code null}.
   */
  void addResultControl(final Control control);
}
