/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2010-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.common.operation;



import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.util.ByteString;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;



/**
 * This interface defines a set of methods which may be used to update a SASL
 * bind request.
 */
@NotExtensible()
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
public interface UpdatableSASLBindRequest
       extends SASLBindRequest, UpdatableBindRequest
{
  /**
   * Specifies the SASL credentials for the bind request, if any.
   *
   * @param  saslMechanism    The name of the SASL mechanism to use.  It must
   *                          not be {@code null}.
   * @param  saslCredentials  The SASL credentials for the bind request.  It may
   *                          be {@code null} if no credentials should be used.
   */
  void setSASLCredentials(final String saslMechanism,
                          final ASN1OctetString saslCredentials);



  /**
   * Converts this SASL bind request to a simple bind request.  After invoking
   * this method, the caller should not make any further attempt to access this
   * SASL bind request object, but should only interact with the
   * {@link UpdatableSimpleBindRequest} object that is returned.
   *
   * @param  dn        The DN to use for the simple bind request.  It must not
   *                   be {@code null} but may be empty for anonymous simple
   *                   authentication (in which case the password must also be
   *                   empty).
   * @param  password  The password to use for the simple bind request.  It
   *                   must not be {@code null} but may be empty for anonymous
   *                   simple authentication (in which case the DN must also be
   *                   empty).
   *
   * @return  The {@code UpdatableSimpleBindRequest} that was created and will
   *          be used for the operation going forward.
   */
  UpdatableSimpleBindRequest convertToSimpleBindRequest(final DN dn,
                                  final ByteString password);
}
