/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2010-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.common.operation;



import java.util.List;

import com.unboundid.ldap.sdk.DereferencePolicy;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;



/**
 * This interface defines a set of methods which may be used to update a search
 * request.
 */
@NotExtensible()
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
public interface UpdatableSearchRequest
       extends SearchRequest, UpdatableRequest
{
  /**
   * Specifies the base DN for the search.
   *
   * @param  baseDN  The base DN for the search.  It must not be {@code null}.
   */
  void setBaseDN(final String baseDN);



  /**
   * Specifies the base DN for the search.
   *
   * @param  baseDN  The base DN for the search.  It must not be {@code null}.
   */
  void setBaseDN(final DN baseDN);



  /**
   * Specifies the scope for the search.
   *
   * @param  scope  The scope for the search.  It must not be {@code null}.
   */
  void setScope(final SearchScope scope);



  /**
   * Specifies the dereference policy for the search.
   *
   * @param  derefPolicy  The dereference policy for the search.  It must not be
   *                      {@code null}.
   */
  void setDerefPolicy(final DereferencePolicy derefPolicy);



  /**
   * Specifies the size limit for the search.  A value less than or equal to
   * zero indicates that no size limit should be requested.
   *
   * @param  sizeLimit  The size limit for the search.
   */
  void setSizeLimit(final int sizeLimit);



  /**
   * Specifies the time limit for the search in seconds.  A value less than or
   * equal to zero indicates that no time limit should be requested.
   *
   * @param  timeLimit  The time limit for the search in seconds.
   */
  void setTimeLimitSeconds(final int timeLimit);



  /**
   * Specifies whether search result entries should contain attribute values.
   *
   * @param  typesOnly  Indicates whether search result entries should contain
   *                    only attribute types or both types and values.
   */
  void setTypesOnly(final boolean typesOnly);



  /**
   * Specifies the filter for the search.
   *
   * @param  filter  The filter for the search.  It must not be {@code null}.
   */
  void setFilter(final Filter filter);



  /**
   * Specifies the filter for the search.
   *
   * @param  filter  The string representation of the filter for the search.  It
   *                 must not be {@code null}.
   *
   * @throws  LDAPException  If the provided string cannot be parsed as a valid
   *                         filter.
   */
  void setFilter(final String filter)
       throws LDAPException;



  /**
   * Specifies the list of requested attributes.
   *
   * @param  attributes  The list of requested attributes.
   */
  void setAttributes(final List<String> attributes);
}
