/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2010-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.common.operation;



import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.util.ByteString;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;



/**
 * This interface defines a set of methods which may be used to update a simple
 * bind request.
 */
@NotExtensible()
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
public interface UpdatableSimpleBindRequest
       extends SimpleBindRequest, UpdatableBindRequest
{
  /**
   * Specifies the DN of the user attempting to bind.
   *
   * @param  dn  The DN of the user that is trying to authenticate.  It must not
   *             be {@code null}, but it may be an empty string to indicate a
   *             zero-length DN.
   */
  void setDN(final String dn);



  /**
   * Specifies the DN of the user attempting to bind.
   *
   * @param  dn  The DN of the user that is trying to authenticate.  It must not
   *             be {@code null}, but it may be an empty string to indicate a
   *             zero-length DN.
   */
  void setDN(final DN dn);



  /**
   * Specifies the password for the bind request.
   *
   * @param  password  The password for the bind request.  It must not be
   *                   {@code null} but may be a zero-length byte string  for
   *                   anonymous authentication.
   */
  void setPassword(final ByteString password);



  /**
   * Specifies the password for the bind request.
   *
   * @param  password  The password for the bind request.  It must not be
   *                   {@code null} but may be a zero-length byte string  for
   *                   anonymous authentication.
   */
  void setPassword(final String password);



  /**
   * Converts this simple bind request to a SASL bind request.  After invoking
   * this method, the caller should not make any further attempt to access this
   * simple bind request object, but should only interact with the
   * {@link UpdatableSASLBindRequest} object that is returned.
   *
   * @param  saslMechanism    The name of the SASL mechanism to use for the
   *                          SASL bind request.  This must not be {@code null}
   *                          or empty.
   * @param  saslCredentials  The encoded SASL credentials to use for the SASL
   *                          bind request.  This may be {@code null} if no
   *                          SASL credentials are needed.
   *
   * @return  The {@code UpdatableSASLBindRequest} that was created and will be
   *          used for the operation going forward.
   */
  UpdatableSASLBindRequest convertToSASLBindRequest(final String saslMechanism,
                                final ASN1OctetString saslCredentials);
}
