/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2010-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.common.schema;



import com.unboundid.util.ByteString;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;



/**
 * This interface provides an API for interacting with equality matching rules,
 * which can be used to determine whether one value is logically equivalent to
 * another.  The definition of "logically equal to" may vary based on the
 * matching rule implementation.
 */
@NotExtensible()
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_THREADSAFE)
public interface EqualityMatchingRule
       extends MatchingRule
{
  /**
   * Indicates whether the provided values are logically equal to each
   * other.
   *
   * @param  normValue1  The normalized form of the first value for which to
   *                     make the determination.
   * @param  normValue2  The normalized form of the second value for which to
   *                     make the determination.
   *
   * @return  {@code true} if the values are considered logically equal to each
   *          other, or {@code false} if not.
   */
  boolean areEqual(final ByteString normValue1, final ByteString normValue2);
}
