/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2010-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.common.types;



import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;



/**
 * This interface defines a set of methods that may be used to obtain
 * information about a search operation that is actively being processed and for
 * which the final response has not yet been sent.
 */
@NotExtensible()
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
public interface ActiveSearchOperationContext
       extends ActiveOperationContext
{
  /**
   * Attempts to send a search result entry to the client.
   *
   * @param  e  The entry to be returned to the client.
   *
   * @throws  LDAPException  If a problem occurs while attempting to send the
   *                         entry and processing on the associated operation
   *                         should be aborted.
   */
  void sendSearchEntry(final SearchResultEntry e)
       throws LDAPException;



  /**
   * Attempts to send a search result reference to the client.
   *
   * @param  r  The reference to be returned to the client.
   *
   * @throws  LDAPException  If a problem occurs while attempting to send the
   *                         reference and processing on the associated
   *                         operation should be aborted.
   */
  void sendSearchReference(final SearchResultReference r)
       throws LDAPException;
}
