/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2013-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.common.types;



import com.unboundid.ldap.sdk.unboundidds.controls.AssuredReplicationLocalLevel;
import com.unboundid.ldap.sdk.unboundidds.controls.
            AssuredReplicationRemoteLevel;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;



/**
 * This interface may be used to obtain information about the assured
 * replication requirements that will be used for an operation.
 */
@NotExtensible()
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_THREADSAFE)
public interface AssuredReplicationRequirements
{
  /**
   * Indicates whether assured replication processing will be performed for the
   * operation.
   *
   * @return  {@code true} if assured replication processing will be performed
   *          for the operation, or {@code false} if not.
   */
  boolean isAssured();



  /**
   * Retrieves the local assurance level that will be used for the operation.
   *
   * @return  The local assurance level that will be used for the operation.
   */
  AssuredReplicationLocalLevel getLocalLevel();



  /**
   * Retrieves the remote assurance level that will be used for the operation.
   *
   * @return  The remote assurance level that will be used for the operation.
   */
  AssuredReplicationRemoteLevel getRemoteLevel();



  /**
   * Retrieves the maximum length of time in milliseconds that the server should
   * wait for assurance processing to complete before returning the operation
   * result to the client.
   *
   * @return  The maximum length of time in milliseconds that the server should
   *          wait for assurance processing to complete before returning the
   *          operation result to the client.
   */
  long getTimeoutMillis();



  /**
   * Indicates whether the operation response to the client will be delayed
   * until replication assurance processing has completed or the timeout has
   * occurred.
   *
   * @return  {@code true} if the operation response to the client will be
   *          delayed until replication assurance processing has completed, or
   *          {@code false} if not.
   */
  boolean isResponseDelayed();



  /**
   * Indicates whether the assured replication requirements that will be used
   * for the operation were altered by an assured replication request control
   * included in the operation request from the client.
   *
   * @return  {@code true} if the assured replication requirements have been
   *          altered by a request control provided by the client, or
   *          {@code false} if the assured replication requirements used for the
   *          operation are taken from a policy defined in the server
   *          configuration.
   */
  boolean isAlteredByRequestControl();
}
