/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2010-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.common.types;



import com.unboundid.util.NotExtensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;



/**
 * This interface defines a set of methods that may be used to obtain
 * information about the authentication and/or authorization identity of a
 * client connection.
 */
@NotExtensible()
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
public interface AuthInfo
{
  /**
   * Indicates whether the associated client has authenticated to the server.
   *
   * @return  {@code true} if the associated client has authenticated to the
   *          server, or {@code false} if not.
   */
  boolean isAuthenticated();



  /**
   * Retrieves the type of authentication performed by the client.
   *
   * @return  The type of authentication performed by the client.
   */
  AuthType getAuthType();



  /**
   * Retrieves the DN of the user that has authenticated, if applicable.
   *
   * @return  The DN of the user that has authenticated, or {@code null} if the
   *          client has not authenticated.
   */
  String getAuthenticationDN();



  /**
   * Retrieves the entry for the user that has authenticated, if applicable.
   *
   * @return  The entry for the user that has authenticated, or {@code null} if
   *          the client has not yet authenticated.
   */
  Entry getAuthenticationEntry();



  /**
   * Retrieves the DN of the authorization identity for the client connection,
   * if applicable.  The authorization identity is usually the same as the
   * authentication identity, but an alternate authorization identity may be
   * specified when authenticating with some SASL mechanisms.
   *
   * @return  The DN of the authorization identity for the connection, or
   *          {@code null} if the client has not yet authenticated or if the
   *          authorization identity is the anonymous user.
   */
  String getAuthorizationDN();



  /**
   * Retrieves the entry for the authorization identity, if applicable.    The
   * authorization identity is usually the same as the authentication identity,
   * but an alternate authorization identity may be specified when
   * authenticating with some SASL mechanisms.
   *
   * @return  The entry for the authorization identity, or {@code null} if the
   *          client has not yet authenticated or if the authorization identity
   *          is the anonymous user.
   */
  Entry getAuthorizationEntry();



  /**
   * Retrieves the name of the SASL mechanism used to authenticate, if
   * applicable.
   *
   * @return  The name of the SASL mechanism used to authenticate, or
   *          {@code null} if the client has not used SASL authentication.
   */
  String getSASLMechanismName();
}
