/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2010-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.common.types;



import com.unboundid.util.NotExtensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;



/**
 * This interface defines a set of methods that may be used to obtain
 * information about a search operation for which processing has been completed.
 */
@NotExtensible()
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
public interface CompletedSearchOperationContext
       extends CompletedOperationContext
{
  /**
   * Retrieves the number of entries that were returned to the client during
   * the course of the search.
   *
   * @return  The number of entries that were returned to the client during the
   *          course of the search.
   */
  long getEntryCount();



  /**
   * Retrieves the number of references that were returned to the client during
   * the course of the search.
   *
   * @return  The number of references that were returned to the client during
   *          the course of the search.
   */
  long getReferenceCount();



  /**
   * Indicates whether the search operation was considered unindexed.
   *
   * @return  {@code true} if the search operation was considered unindexed, or
   *          {@code false} if not.
   */
  boolean isUnindexed();
}
