/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2014-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.common.types;



/**
 * This interface may be used to interact with an alert type that may cause the
 * server to be classified as degraded.
 */
public interface DegradedAlertType
{
  /**
   * Retrieves the alert type name for this degraded alert type.
   *
   * @return  The alert type name for this degraded alert type.
   */
  String getAlertTypeName();



  /**
   * Retrieves the OID for this degraded alert type.
   *
   * @return  The OID for this degraded alert type.
   */
  String getAlertTypeOID();



  /**
   * Retrieves the severity for this degraded alert type.
   *
   * @return  The severity for this degraded alert type.
   */
  AlertSeverity getAlertSeverity();



  /**
   * Indicates that the condition that triggered this degraded alert type has
   * been resolved and should no longer cause the server to be considered
   * degraded.
   */
  void setResolved();
}
