/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Portions Copyright 2007-2019 Ping Identity Corporation
 *      Portions Copyright 2006-2008 Sun Microsystems, Inc.
 */
package com.unboundid.directory.sdk.common.types;



/**
 * This enumeration defines the set of possible reasons for the closure of a
 * connection between a client and the server.
 */
public enum DisconnectReason
{
  /**
   * The disconnect reason that indicates that the client connection was closed
   * because the client unbind from the server.
   */
  UNBIND("Client Unbind"),



  /**
   * The disconnect reason that indicates that the client connection was closed
   * because the client disconnected without unbinding.
   */
  CLIENT_DISCONNECT("Client Disconnect"),



  /**
   * The disconnect reason that indicates that the client connection was closed
   * because the client connection was rejected.
   */
  CONNECTION_REJECTED("Client Connection Rejected"),



  /**
   * The disconnect reason that indicates that the client connection was closed
   * because of an I/O error.
   */
  IO_ERROR("I/O Error"),



  /**
   * The disconnect reason that indicates that the client connection was closed
   * because of a protocol error.
   */
  PROTOCOL_ERROR("Protocol Error"),



  /**
   * The disconnect reason that indicates that the client connection was closed
   * because the Directory Server shut down.
   */
  SERVER_SHUTDOWN("Server Shutdown"),



  /**
   * The disconnect reason that indicates that the client connection was closed
   * because an administrator terminated the connection.
   */
  ADMIN_DISCONNECT("Administrative Termination"),



  /**
   * The disconnect reason that indicates that the client connection was closed
   * because of a security problem.
   */
  SECURITY_PROBLEM("Security Problem"),



  /**
   * The disconnect reason that indicates that the client connection was closed
   * because the maximum allowed request size was exceeded.
   */
  MAX_REQUEST_SIZE_EXCEEDED("Maximum Request Size Exceeded"),



  /**
   * The disconnect reason that indicates that the client connection was closed
   * because an administrative limit was exceeded.
   */
  ADMIN_LIMIT_EXCEEDED("Administrative Limit Exceeded"),



  /**
   * The disconnect reason that indicates that the client connection was closed
   * because the idle time limit was exceeded.
   */
  IDLE_TIME_LIMIT_EXCEEDED("Idle Time Limit Exceeded"),



  /**
   * The disconnect reason that indicates that the client connection was closed
   * because of an I/O timeout.
   */
  IO_TIMEOUT("I/O Timeout"),



  /**
   * The disconnect reason that indicates that the client connection
   * was closed because of an internal error within the server.
   */
  SERVER_ERROR("Server Error"),



  /**
   * The disconnect reason that indicates that the client connection
   * was closed by a plugin.
   */
  CLOSED_BY_PLUGIN("Connection Closed by Plugin"),



  /**
   * The disconnect reason that indicates that the client connection
   * was closed for some other reason.
   */
  OTHER("Unknown Closure Reason");



  // The disconnect reason.
  private final String message;


  /**
   * Creates a new disconnect reason element with the provided closure message.
   *
   * @param  message  The message for this disconnect reason.
   */
  DisconnectReason(final String message)
  {
    this.message = message;
  }



  /**
   * Retrieves the human-readable disconnect reason.
   *
   * @return  The human-readable disconnect reason.
   */
  public String getClosureMessage()
  {
    return message;
  }



  /**
   * Retrieves a string representation of this disconnect reason.
   *
   * @return  A string representation of this disconnect reason.
   */
  @Override()
  public String toString()
  {
    return message;
  }
}
