/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2011-2019 Ping Identity Corporation
 */

package com.unboundid.directory.sdk.common.types;

/**
 * This class defines a structure which may be used to provide information about
 * the manage extension installation state.
 */
public final class InstallExtensionDetails
{
  // The bundle being installed.
  private final ExtensionBundle extensionBundle;

  /**
   * Creates a new install extension details with the provided
   * information.
   *
   * @param extensionBundle The extension bundle being installed.
   */
  public InstallExtensionDetails(final ExtensionBundle extensionBundle)
  {
    this.extensionBundle = extensionBundle;
  }

  /**
   * Retrieves the extension bundle being installed.
   *
   * @return The extension bundle being installed.
   */
  public ExtensionBundle getExtensionBundle()
  {
    return extensionBundle;
  }
}
