/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Portions Copyright 2007-2019 Ping Identity Corporation
 *      Portions Copyright 2007-2008 Sun Microsystems, Inc.
 */
package com.unboundid.directory.sdk.common.types;



import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;



/**
 * This enum defines the set of severities that may be used for error log
 * messages.
 */
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum LogCategory
{

  /**
   * The category used for messages associated with Access Control.
   */
  ACCESS_CONTROL,



  /**
   * The category used for messages associated with the
   * administration framework.
   */
  ADMIN,



  /**
   * The category used for messages associated with the tool like the
   * offline installer and uninstaller.
   */
  ADMIN_TOOL,



  /**
   * The category used for messages associated with generic backends.
   */
  BACKEND,



  /**
   * The category that will be used for messages associated with
   * configuration handling.
   */
  CONFIG,



  /**
   * The category that will be used for messages associated with the
   * core server.
   */
  CORE,



  /**
   * The category used for messages associated with the dsconfig
   * administration tool.
   */
  DSCONFIG,



  /**
   * The category that will be used for messages associated with server
   * extensions (e.g., extended operations, SASL mechanisms, password storage
   * schemes, password validators, etc.).
   */
  EXTENSIONS,



  /**
   * The category used for messages associated with the JE backend.
   */
  JEB,



  /**
   * The category that will be used for messages associated with the
   * server loggers.
   */
  LOG,



  /**
   * The category that will be used for messages associated with plugin
   * processing.
   */
  PLUGIN,



  /**
   * The category that will be used for messages associated with
   * connection and protocol handling (e.g., ASN.1 and LDAP).
   */
  PROTOCOL,



  /**
   * The category that will be used for messages associated with Directory Proxy
   * Server functionality.
   */
  PROXY,



  /**
   * The category used for messages associated with replication.
   */
  REPLICATION,



  /**
   * The category used for messages associated with the runtime information.
   */
  RUNTIME_INFORMATION,



  /**
   * The category that will be used for messages associated with the
   * server schema elements.
   */
  SCHEMA,



  /**
   * The category used for messages associated with the setup tools.
   */
  SETUP,



  /**
   * The category that will be used for messages associated with
   * ${SYNC_SERVER_BASE_NAME} functionality.
   */
  SYNC,



  /**
   * The category used for messages associated with tasks.
   */
  TASK,



  /**
   * The category that will be used for messages associated with
   * third-party (including user-defined) modules.
   */
  THIRD_PARTY,



  /**
   * The category used for messages associated with tools.
   */
  TOOLS,



  /**
   * The category that will be used for messages associated with the updater
   * tool.
   */
  UPDATE,



  /**
   * The category that will be used for messages associated with
   * user-defined modules.
   */
  USER_DEFINED,



  /**
   * The category that will be used for messages associated with the
   * general server utilities.
   */
  UTIL,



  /**
   * The category used for messages associated with version information.
   */
  VERSION;
}
