/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2010-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.common.types;



import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;



/**
 * This enum defines the set of severities that may be used for error log
 * messages.
 */
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum LogSeverity
{
  /**
   * This severity should be used for messages about the most severe types of
   * errors which may prevent the server from continuing to function.
   */
  FATAL_ERROR,



  /**
   * This severity should be used for messages about severe errors which may
   * interfere with the function of the server.
   */
  SEVERE_ERROR,



  /**
   * This severity should be used for messages about errors which may interfere
   * with the processing of the task at hand, but should not have any lasting
   * impact on the overall operation of the server.
   */
  MILD_ERROR,



  /**
   * This severity should be used for messages about warning conditions which
   * may lead to problems which could interfere with the operation of the
   * server.
   */
  SEVERE_WARNING,



  /**
   * This severity should be used for messages about warning conditions which
   * may lead to problems which could interfere with the processing of the
   * task at hand.
   */
  MILD_WARNING,



  /**
   * This severity should be used for messages about significant events that
   * occur within the server which may provide administrators with valuable
   * information about the operation of the server.
   */
  NOTICE,



  /**
   * This severity should be used for informational messages about general
   * processing occurring within the server which may be helpful when
   * troubleshooting but are not necessarily important enough to make available
   * to administrators under normal conditions.
   */
  INFO,



  /**
   * This severity should be used for the most verbose types of messages which
   * should only be used when debugging a problem.
   */
  DEBUG;
}
