/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Portions Copyright 2011-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.common.types;

import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;


/**
 * This interface provides methods to interact with a log writer within the
 * core server logging framework.
 */
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public interface LogWriter
{

  /**
   * Writes the given message to the underlying logger.
   * <p>
   * A timestamp will automatically be prepended to the message, and an
   * end-of-line marker will be added to the end. The message can contain its
   * own EOLs if it needs to span multiple lines, but the server will always add
   * one at the very end.
   *
   * @param message the message to log.
   */
  void write(CharSequence message);

}
