/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2011-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.common.types;



import java.io.Serializable;
import java.util.List;

import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;



/**
 * This class defines a structure which may be used to provide information about
 * the result of the processing performed by a manage extension plugin.
 */
@NotMutable()
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class PreManageExtensionPluginResult
       implements Serializable
{
  /**
   * A predefined result instance that indicates all processing completed
   * successfully.
   */
  public static final PreManageExtensionPluginResult SUCCESS =
       new PreManageExtensionPluginResult(true, null);


  /**
   * The serial version UID for this serializable class.
   */
  private static final long serialVersionUID = -5058225898311204645L;

  // Indicates whether the manage-extension tool should continue with the
  // installation.
  private final boolean continueInstallation;

  private final List<String> messages;



  /**
   * Creates a new pre manage extension plugin result with the provided
   * information.
   *
   * @param  continueInstallation  Indicates whether the manage-extension tool
   *                               should continue with the installation.
   * @param  messages              Messages to print to the console or
   *                               <code>null</code>.
   */
  public PreManageExtensionPluginResult(final boolean continueInstallation,
                                        final List<String> messages)
  {
    this.continueInstallation = continueInstallation;
    this.messages = messages;
  }


  /**
   * Indicates whether the manage-extension tool should continue with the
   * installation.
   *
   * @return  {@code true} the manage-extension tool should continue with the
   * installation, or {@code false} if not.
   */
  public boolean continueInstallation()
  {
    return continueInstallation;
  }



  /**
   * Retrieves the list of messages to print to the console.
   *
   * @return  The list of messages to print to the console or <code>null</code>
   *          if no messages are to be printed.
   */
  public List<String> getMessages()
  {
    return messages;
  }


  /**
   * Retrieves a string representation of this pre manage extension plugin
   * result.
   *
   * @return  A string representation of this pre manage extension plugin
   * result.
   */
  @Override()
  public String toString()
  {
    final StringBuilder buffer = new StringBuilder();

    buffer.append("PreManageExtensionPluginResult(continueInstallation=");
    buffer.append(continueInstallation);
    buffer.append(", messages=");
    buffer.append(messages);
    buffer.append(')');

    return buffer.toString();
  }
}
