/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file. If applicable, add the following below this CDDL HEADER,
 * with the fields enclosed by brackets "[]" replaced with your own
 * identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2014-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.common.types;

import com.unboundid.directory.sdk.common.api.OperationCompletedListener;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

/**
 * This interface is used to mark an object which has been registered with the
 * server as an operation completed listener. This is used to cancel a
 * previously registered operation completed listener.
 */
@NotExtensible
@ThreadSafety(level = ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
public interface RegisteredOperationCompletedListener {
  /**
   * Retrieves a reference to the operation completed listener that was
   * registered with the server.
   *
   * @return  A reference to the operation completed listener that was
   *          registered with the server.
   */
  OperationCompletedListener getOperationCompletedListener();
}
