/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2013-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.common.types;

import java.util.List;

/**
 * This can be used to internally execute select command line utilities and
 * return the results.  A Server SDK extension can get access to a ToolExecutor
 * by calling the {@link ServerContext#getToolExecutor()} method.
 */
public interface ToolExecutor
{
  /**
   * Invokes the config-diff command line utility and returns the result.
   * All command line arguments of config-diff are supported with the
   * exception of the debugging arguments listed in --help-debug.  Invocations
   * of this method should behave identically to an explicit command line
   * invocation except the command is run within the current process as
   * opposed to launching an external process.
   *
   * @param args  The arguments to use when invoking config-diff.
   *
   * @return  The result of the config-diff invocation.
   */
  ToolResult runConfigDiff(List<String> args);
}
