/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2013-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.common.types;

import java.io.BufferedReader;

/**
 * Returns the result of a command line utility.
 */
public interface ToolResult
{
  /**
   * Returns the return code of the command.  See the command line help for the
   * individual commands to see how to interpret the return codes.
   *
   * @return  The return code of the command execution.
   */
  int getReturnCode();



  /**
   * Returns what the command wrote to stdout as a String.
   *
   * @return  What the command wrote to stdout as a String.
   */
  String getStdoutAsString();



  /**
   * Returns what the command wrote to stdout as a BufferedReader.
   *
   * @return  What the command wrote to stdout as a BufferedReader.
   */
  BufferedReader getStdoutAsReader();



  /**
   * Returns what the command wrote to stderr as a String.
   *
   * @return  What the command wrote to stderr as a String.
   */
  String getStderrAsString();



  /**
   * Returns what the command wrote to stderr as a BufferedReader.
   *
   * @return  What the command wrote to stderr as a BufferedReader.
   */
  BufferedReader getStderrAsReader();
}
