/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2013-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.common.types;


/**
 * Context used to provide named objects to Velocity templates as they are
 * they are used to render output.  Objects stored in context are available
 * to templates as they are rendered using variable references like
 * '$variable'.
 *
 * See http://velocity.apache.org/ for more information on using Velocity.
 */
public interface VelocityContext
{


  /**
   * Indicates whether a call to {@code put} will update this context
   * if a value already exists in the context by the specified key.
   *
   * @return  boolean where true indicates overrides are permitted.
   */
  boolean isPermitOverrides();



  /**
   * Adds a named object to this context.  If overrides are not permitted
   * and an object already exists in this context for the given key this
   * method will throw a runtime exception.  Following a successful call
   * to this method, the object will be available to templates using a
   * reference like '$key'.
   *
   * @param key   The key with which to store the object in context.
   *              Keys prefixed with a '_' are reserved for internal use.
   *              Attempting to set a named object using a key prefixed with
   *              '_' will throw a runtime exception.  Likewise attempting to
   *              put a named object in this context with a previously used
   *              key in which overrides are not permitted with throw a
   *              runtime exception.
   *
   * @param value The context value.
   *
   * @return The old object or null if there was no old object.
   */
  Object put(String key, Object value);



  /**
   * Gets the named object associated with a given key.
   *
   * @param key associated with the named object.
   *
   * @return The associated named object within this context or {@code null}
   *         if no object exists for the given key.
   */
  Object get(String key);



  /**
   * Indicates whether a named object exists in this context for a given key.
   *
   * @param key  to use for checking whether an associated object exists in
   *             this context.
   *
   * @return boolean where true indicates a named object exists for the given
   *         key.
   */
  boolean containsKey(Object key);



  /**
   * Obtains an array of all keys for this context.
   *
   * @return array of all keys for this context.
   */
  Object[] getKeys();



  /**
   * Removes the value associated with the specified key from the context.
   *
   * @param key The name of the value to remove.
   *
   * @return The value the key was mapped to, or {@code null} the key
   *         was not previously associated with any named object in this
   *         context.
   */
  Object remove(Object key);

}
