/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * trunk/ds/resource/legal-notices/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * trunk/ds/resource/legal-notices/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.common.types;



import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;



/**
 * This class provides version information for the UnboundID Server SDK.
 * It has been automatically generated during the build process.  Do not
 * manually edit this file.
 */
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class Version
{
  /**
   * The official full product name for the Server SDK.
   * For this build, the value is:
   * "UnboundID Server SDK".
   */
  public static final String PRODUCT_NAME =
       "UnboundID Server SDK";



  /**
   * The short product name for the Server SDK, without any spaces.
   * For this build, the value is:
   * "unboundid-server-sdk".
   */
  public static final String SHORT_NAME =
       "unboundid-server-sdk";



  /**
   * The major version number for the Server SDK.
   * For this build, the value is:
   * "7".
   */
  public static final int MAJOR_VERSION = 7;



  /**
   * The minor version number for the Server SDK.
   * For this build, the value is:
   * "3".
   */
  public static final int MINOR_VERSION = 3;



  /**
   * The point version number for the Server SDK.
   * For this build, the value is:
   * "0".
   */
  public static final int POINT_VERSION = 0;



  /**
   * The patch version number for the Server SDK.
   * For this build, the value is:
   * "0".
   */
  public static final int PATCH_VERSION = 0;



  /**
   * The version qualifier string for the Server SDK.
   * For this build, the value is:
   * "".
   */
  public static final String VERSION_QUALIFIER =
       "";



  /**
   * The version number string for the Server SDK.
   * For this build, the value is:
   * "7.3.0.0".
   */
  public static final String VERSION_NUMBER_STRING =
       "7.3.0.0";



  /**
   * The full version string for the Server SDK.
   * For this build, the value is:
   * "UnboundID Server SDK 7.3.0.0".
   */
  public static final String FULL_VERSION_STRING =
       "UnboundID Server SDK 7.3.0.0";



  /**
   * The compact version string for the Server SDK, without any spaces.
   * For this build, the value is:
   * "unboundid-server-sdk-7.3.0.0".
   */
  public static final String COMPACT_VERSION_STRING =
       "unboundid-server-sdk-7.3.0.0";



  /**
   * A timestamp indicating when the Server SDK was built as a GMT time.
   * For this build, the value is:
   * "20190621165504Z".
   */
  public static final String BUILD_TIMESTAMP =
       "20190621165504Z";



  /**
   * The source repository branch from which the Server SDK was built.
   * For this build, the value is:
   * "/directory/branches/ds-7.3".
   */
  public static final String REPOSITORY_PATH =
       "/directory/branches/ds-7.3";



  /**
   * The source repository revision ID from which the Server SDK was built.
   * For this build, the value is:
   * "30805".
   */
  public static final String REVISION_ID =
       "30805";



  /**
   * Prints version information for the UnboundID Server SDK to standard output.
   *
   * @param  args  The command-line arguments provided to this program.
   */
  public static void main(final String... args)
  {
    System.out.println("Full Version String:   " + FULL_VERSION_STRING);
    System.out.println("Short Version String:  " + COMPACT_VERSION_STRING);
    System.out.println("Product Name:          " + PRODUCT_NAME);
    System.out.println("Short Name:            " + SHORT_NAME);
    System.out.println("Major Version:         " + MAJOR_VERSION);
    System.out.println("Minor Version:         " + MINOR_VERSION);
    System.out.println("Point Version:         " + POINT_VERSION);
    System.out.println("Patch Version:         " + PATCH_VERSION);
    System.out.println("Version Qualifier:     " + VERSION_QUALIFIER);
    System.out.println("Build Timestamp:       " + BUILD_TIMESTAMP);
    System.out.println("Source Branch:         " + REPOSITORY_PATH);
    System.out.println("Source Revision:       " + REVISION_ID);
  }
}
