/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2011-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.ds.api;

import com.unboundid.directory.sdk.ds.internal.DirectoryServerExtension;
import com.unboundid.directory.sdk.ds.types.BackendContext;
import com.unboundid.util.Extensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

/**
 * This interface defines a set of methods that may be used by extensions
 * to perform any processing that they might find necessary
 * whenever a backend is initialized and/or finalized.
 */
@Extensible()
@DirectoryServerExtension()
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_THREADSAFE)
public abstract class BackendInitializationListener
{

  /**
   * Performs any processing that may be required whenever a backend
   * has been registered for use in the Directory Server. This method will
   * be invoked after the backend has been initialized and put into service.
   *
   * @param backendContext The backend that has been initialized and put into
   *                       service.
   */
  public abstract void backendInitialized(BackendContext backendContext);



  /**
   * Performs any processing that may be required whenever a backend
   * is de-registered from the Directory Server. This method will
   * be invoked before the backend has been taken out of service.
   *
   * @param backendContext The backend that is about to be taken out of service.
   */
  public abstract void backendFinalized(BackendContext backendContext);

}
