/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2010-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.ds.scripting;



import com.unboundid.directory.sdk.common.internal.Configurable;
import com.unboundid.directory.sdk.ds.internal.DirectoryServerExtension;
import com.unboundid.directory.sdk.ds.types.DirectoryServerContext;
import com.unboundid.directory.sdk.ds.types.TaskContext;
import com.unboundid.directory.sdk.ds.types.TaskReturnState;
import com.unboundid.directory.sdk.proxy.internal.DirectoryProxyServerExtension;
import com.unboundid.directory.sdk.sync.internal.SynchronizationServerExtension;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.util.Extensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;



/**
 * This class defines an API that must be implemented by scripted extensions
 * which may be used as administrative tasks.  Administrative tasks have the
 * ability to perform arbitrary processing within the server whenever a
 * particular kind of entry is added, and that processing can be performed
 * immediately or at some specified time in the future.  Tasks may be scheduled
 * by adding an entry below "cn=Scheduled Tasks,cn=tasks" with a format like
 * the following:
 * <PRE>
 *   dn:  ds-task-id=TASKID,cn=Scheduled Tasks,cn=tasks
 *   objectClass: top
 *   objectClass: ds-task
 *   objectClass: ds-groovy-scripted-task
 *   ds-task-id: TASKID
 *   ds-task-class-name: com.unboundid.directory.sdk.extensions.GroovyScrip
 *    tedTask
 *   ds-scripted-task-class: com.example.ExampleGroovyTask
 *   ds-scripted-task-argument: name=value
 * </PRE>
 * In this example, TASKID should be replaced with a string that uniquely
 * identifies the task.  The value of the ds-scripted-task-class attribute
 * should contain the fully-qualified name of the non-abstract Groovy class that
 * extends this com.unboundid.directory.sdk.scripting.ScriptedTask class, and
 * the ds-scripted-task-argument values (if any) should reflect the set of
 * arguments to be provided for the task.
 * method.
 * <BR><BR>
 * Alternately, the com.unboundid.ldap.sdk.unboundidds.tasks.GroovyScriptedTask
 * class included in the Commercial Edition of the UnboundID LDAP SDK for Java
 * may be used to schedule and interact with these kinds of tasks.  See the
 * documentation for the Commercial Edition of the LDAP SDK for more
 * information on using the UnboundID LDAP SDK for Java to schedule and interact
 * with administrative tasks.
 *
 * @see  com.unboundid.directory.sdk.ds.api.Task
 */
@Extensible()
@DirectoryServerExtension()
@DirectoryProxyServerExtension(appliesToLocalContent=true,
     appliesToRemoteContent=false)
@SynchronizationServerExtension(appliesToLocalContent=true,
     appliesToSynchronizedContent=false)
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_THREADSAFE)
public abstract class ScriptedTask
       implements Configurable
{
  /**
   * Creates a new instance of this task.  All task implementations must include
   * a default constructor, but any initialization should generally be done in
   * the {@code initializeTask} method.
   */
  public ScriptedTask()
  {
    // No implementation is required.
  }



  /**
   * {@inheritDoc}
   */
  public void defineConfigArguments(final ArgumentParser parser)
         throws ArgumentException
  {
    // No arguments will be allowed by default.
  }



  /**
   * Initializes this task.
   *
   * @param  serverContext  A handle to the server context for the server in
   *                        which this extension is running.
   * @param  parser         The argument parser which has been initialized from
   *                        the configuration for this task.
   *
   * @throws  LDAPException  If a problem occurs while initializing this task.
   */
  public void initializeTask(final DirectoryServerContext serverContext,
                             final ArgumentParser parser)
         throws LDAPException
  {
    // No initialization will be performed by default.
  }



  /**
   * Performs the appropriate processing for this task.
   *
   * @param  taskContext  Information about the task to be run.
   *
   * @return  Information about the state of the task after processing has
   *          completed.
   */
  public abstract TaskReturnState runTask(final TaskContext taskContext);
}
