/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file. If applicable, add the following below this CDDL HEADER,
 * with the fields enclosed by brackets "[]" replaced with your own
 * identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Portions Copyright 2007-2019 Ping Identity Corporation
 *      Portions Copyright 2006-2008 Sun Microsystems, Inc.
 */
package com.unboundid.directory.sdk.ds.types;



import java.util.List;
import java.util.Map;

import com.unboundid.directory.sdk.common.types.Entry;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;


/**
 * This class defines a data type for storing information associated
 * with an account status notification.
 */
@ThreadSafety(level= ThreadSafetyLevel.INTERFACE_THREADSAFE)
public interface AccountStatusNotification
{
  /**
   * Retrieves the notification type for this account status notification.
   *
   * @return  The notification type for this account status notification.
   */
  AccountStatusNotificationType getNotificationType();



  /**
   * Retrieves the DN of the user entry to which this notification applies.
   *
   * @return  The DN of the user entry to which this notification applies.
   */
  String getUserDN();



  /**
   * Retrieves the user entry for whom this notification applies.
   *
   * @return  The user entry for whom this notification applies.
   */
  Entry getUserEntry();



  /**
   * Retrieves a message that provides additional information for this account
   * status notification.
   *
   * @return  A message that provides additional information for this account
   *          status notification.
   */
  String getMessage();



  /**
   * Retrieves a set of properties that may provide additional information for
   * this account status notification.
   *
   * @return  A set of properties that may provide additional information for
   *          this account status notification.
   */
  Map<AccountStatusNotificationProperty,List<String>>
       getNotificationProperties();



  /**
   * Retrieves the set of values for the specified account status notification
   * property.
   *
   * @param  property  The account status notification property for which to
   *                   retrieve the associated values.
   *
   * @return  The set of values for the specified account status notification
   *          property, or {@code null} if the specified property is not defined
   *          for this account status notification.
   */
  List<String> getNotificationProperty(
                    final AccountStatusNotificationProperty property);



  /**
   * Retrieves a string representation of this account status notification.
   *
   * @return  A string representation of this account status notification.
   */
  String toString();
}

