/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2010-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.ds.types;



import com.unboundid.util.NotExtensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;



/**
 * This interface defines a set of methods that may be used to interact with a
 * change subscription that has been defined in the server.
 */
@NotExtensible()
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
public interface ChangeSubscription
{
  /**
   * Retrieves the name of this change subscription.
   *
   * @return  The name of this change subscription.
   */
  String getName();



  /**
   * Retrieves the DN of the configuration entry defining this change
   * subscription.
   *
   * @return  The DN of the configuration entry defining this change
   *          subscription.
   */
  String getDN();



  /**
   * Retrieves the expiration time for this change subscription.    The value
   * returned will be an offset in milliseconds since 12:00 a.m. on January 1,
   * 1970.
   *
   * @return  The expiration time for this change subscription, or
   *          {@code Long.MAX_VALUE} if none is defined.
   */
  long getExpirationTime();
}
