/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2012-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.ds.types;



import com.unboundid.util.NotExtensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;



/**
 * This interface may be used to obtain information about the result of
 * processing a SASL bind operation in which the authentication attempt failed.
 */
@NotExtensible()
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public interface FailureSASLBindResult
       extends SASLBindResult
{
  /**
   * Retrieves a message with potentially detailed information about the reason
   * for the authentication failure.  This message will not be included in the
   * response to the client, but may be included in the server access log in
   * order to help administrators better understand the failure.
   *
   * @return  A message with potentially detailed information about the reason
   *          for the authentication failure.
   */
  String getAuthenticationFailureReason();



  /**
   * Retrieves the DN of the user that tried to authenticate but was unable to
   * do so successfully, if known.
   *
   * @return  The DN of the user that tried to authenticate but was unable to
   *          do so successfully, or {@code null} if the identity of the user is
   *          not known.
   */
  String getUnsuccessfullyAuthenticatedUserDN();
}
