/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2014-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.ds.types;



import com.unboundid.util.NotExtensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

import java.util.Date;
import java.util.List;



/**
 * This interface defines a set of methods that may be used to obtain
 * information about a notification to be delivered by a notification
 * manager.
 */
@NotExtensible()
@ThreadSafety(level= ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
public interface Notification
{
  /**
   * Retrieve the notification destination ID.
   *
   * @return  The notification destination ID.
   */
  String getDestinationID();



  /**
   * Retrieve the list of changes associated with the notification.
   * A notification can include more than one change when the changes are
   * part of an external transaction (e.g. a multi-update extended operation),
   * unless the notification manager is configured to treat the changes
   * individually.
   *
   * @return  The list of changes associated with the notification. The
   *          returned list may not be modified.
   */
  List<NotificationChange> getNotificationChanges();



  /**
   * Retrieve the number of previous delivery attempts for this notification.
   *
   * @return  The number of previous delivery attempts for this notification.
   */
  int getNumPreviousDeliveryAttempts();



  /**
   * Retrieve the time at which the first delivery attempt was made, or
   * {@code null} if there have been no previous delivery attempts.
   *
   * @return  The time at which the first delivery attempt was made, or
   *          {@code null} if there have been no previous delivery attempts.
   */
  Date getTimeOfFirstDeliveryAttempt();



  /**
   * Retrieve the time at which the last delivery attempt was made, or
   * {@code null} if there have been no previous delivery attempts.
   *
   * @return  The time at which the last delivery attempt was made, or
   *          {@code null} if there have been no previous delivery attempts.
   */
  Date getTimeOfLastDeliveryAttempt();
}
