/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2014-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.ds.types;

import com.unboundid.ldap.sdk.unboundidds.UnboundIDChangeLogEntry;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

import java.util.Map;



/**
 * This interface defines a set of methods that may be used to obtain
 * information about a single change in a notification to be delivered by a
 * notification manager. A notification can include more than one change when
 * the changes are part of an external transaction (e.g. a multi-update
 * extended operation), unless the notification manager is configured to treat
 * the changes individually.
 */
@NotExtensible()
@ThreadSafety(level= ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
public interface NotificationChange
{
  /**
   * Retrieve the change log entry for the change that was made.
   *
   * @return  The change log entry for the change that was made.
   */
  UnboundIDChangeLogEntry getChangeLogEntry();



  /**
   * Retrieve the properties provided by the notification manager for this
   * change by one of the {@code get*NotificationProperties} methods. The
   * returned properties may not be modified.
   *
   * @return  The properties provided by the notification manager for this
   *          change. The returned properties may not be modified.
   */
  Map<String,String> getProperties();
}
