/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2014-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.ds.types;

import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;



/**
 * This class implements an enumeration that may be used to define the
 * ways in which an attribute may be indexed within the directory server.
 */
@ThreadSafety(level= ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum NotificationDeliveryResult
{
  /**
   * The notification was successfully delivered.
   */
  SUCCESS,

  /**
   * The notification could not be delivered and delivery should not be retried.
   */
  FAILURE,

  /**
   * The notification could not be delivered but delivery should be retried.
   * Notification manager implementations should be careful not to return
   * {@code RETRY} when all future attempts of the notification delivery will
   * fail, e.g. a remote change failing due to a schema violation. If the
   * extension can determine that the remote service is completely unavailable,
   * then it is fine to continue to retry, but if the service is available
   * and only failing for some changes, then continuing to retry is dangerous.
   * There are methods on the {@code Notification} interface to determine how
   * many attempts have been made and for how long attempts have been made.
   * Above some threshold, the extension should return {@code FAILURE} instead
   * of {@code RETRY}.
   */
  RETRY
}
